function estpar0 = LWM_parm_extend(x0s,x0k,M1,M2,Srange,sfit,kfit)
%==========================================================================================
%This function extends a M-LWM density parameter vector to the (M+1)-LWM
%density with M1 Lognormal component and M2 Weibull component
%
%INPUT:
%   x0s: parameter estimates for the M1 lognormal component
%   x0k: parameter estimates for the M2 Weibull component
%   M1: non-negative integer scalar, number of Lognormal densities in the mixture
%   M2: non-negative integer scalar, number of Weibull densities in the mixture
%   Srange: Strike range used to draw a initial value for Ft of a new density
%   sfit: fitted sigma value of the 1-mixture Lognormal distribution
%   kfit: fitted k value of the 1-mixture Lognormal distribution
%
%OUTPUT:
%   estpar0: initial parameter vector for (M+1)-LWM mixture
%==========================================================================================
% This ver: 2023/05/24
% Authors: Yifan Li (yifan.li@manchester.ac.uk)
%          Ingmar Nolte (i.nolte@lancaster.ac.uk)
%          Manh Pham (m.c.pham@lancaster.ac.uk)
% Reference: Li, Y., Nolte, I., and Pham, M. C. (2023). Parametric Risk-Neutral 
%          Density Estimation via Finite Lognormal-Weibull Mixtures
%========================================================================================== 

[M1_old,~]=size(x0s);
[M2_old,~]=size(x0k);

M1_add = M1-M1_old;
M2_add = M2-M2_old;

x0s_add =[zeros(M1_add,1) unifrnd(Srange(1),Srange(end),M1_add,1) unifrnd(0.5*sfit,2*sfit,M1_add,1) ];
x0k_add =[zeros(M2_add,1) unifrnd(Srange(1),Srange(end),M2_add,1) unifrnd(0.5*kfit,2*kfit,M2_add,1) ];

estpar0 = reshape([x0s; x0s_add; x0k;x0k_add],3*(M1+M2),1);


end

